#!/bin/bash

set -ouex pipefail

PENTAHO_VERSION="9.4.0.0-343"
SRC_URL="https://github.com/ambientelivre/legacy-pentaho-ce/releases/download/pdi-ce-${PENTAHO_VERSION}/pdi-ce-${PENTAHO_VERSION}.zip"

curl -s -L --retry 5 --retry-delay 10 -o /tmp/data-integration.zip $SRC_URL

unzip /tmp/data-integration.zip -d /usr/lib

mv /usr/lib/data-integration /usr/lib/pentaho-data-integration

install -Dm0644 -t /usr/share/icons /usr/lib/pentaho-data-integration/spoon.png

curl -s -L --retry 5 --retry-delay 10 -o /usr/lib/pentaho-data-integration/lib/ojdbc7.jar https://public.dusansimic.me/ojdbc7.jar

# cleanup
rm -rf /tmp/data-integration.zip
