#!/bin/bash

set -ouex pipefail

BOOSTER_VER="9.1.6"
BOOSTER_VER_MAJ="${BOOSTER_VER%%.*}"

SRC_FILENAME="nosqlbooster4mongo-$BOOSTER_VER.tar.gz"
SRC_URL="https://s3.nosqlbooster.com/download/releasesv$BOOSTER_VER_MAJ/$SRC_FILENAME"

curl --progress-bar -L --retry 5 --retry-delay 10 -o /tmp/nosqlbooster4mongo.tar.gz $SRC_URL

install -d /usr/lib/nosqlbooster4mongo
install -d /usr/bin

tar --no-same-owner -xf /tmp/nosqlbooster4mongo.tar.gz -C /usr/lib/nosqlbooster4mongo --strip-components=1
ln -s /usr/lib/nosqlbooster4mongo/nosqlbooster4mongo  /usr/bin/nosqlbooster4mongo

curl --progress-bar -L --retry 5 --retry-delay 10 -o /tmp/nosqlbooster-icons.tar.xz https://public.dusansimic.me/nosqlbooster-icons.tar.xz
install -d /tmp/nosqlbooster-icons
tar --no-same-owner -xf /tmp/nosqlbooster-icons.tar.xz -C /tmp/nosqlbooster-icons
rsync -rvK /tmp/nosqlbooster-icons/ /usr/share/icons/hicolor/

# cleanup
rm -rf /tmp/nosqlbooster4mongo.tar.gz
rm -rf /tmp/nosqlbooster-icons.tar.xz
rm -rf /tmp/nosqlbooster-icons
