#!/bin/bash

set -ouex pipefail

IDEA_REL="2025.2.4"

SRC_FILENAME="ideaIU-$IDEA_REL.tar.gz"
SRC_URL="https://download.jetbrains.com/idea/$SRC_FILENAME"

curl -L --retry 5 --retry-delay 10 --progress-bar -o /tmp/idea.tar.gz $SRC_URL

install -d /usr/lib/jetbrains-intellij-idea-ultimate
install -d /usr/bin

tar \
  --no-same-owner \
  -xf /tmp/idea.tar.gz \
  -C /usr/lib/jetbrains-intellij-idea-ultimate \
  --strip-components=1

ln -s /usr/lib/jetbrains-intellij-idea-ultimate/bin/idea /usr/bin/jetbrains-intellij-idea-ultimate

install -Dm0644 \
  /usr/lib/jetbrains-intellij-idea-ultimate/bin/idea.svg \
  /usr/share/icons/hicolor/scalable/apps/jetbrains-intellij-idea-ultimate.svg

# cleanup tmp files to save space
rm -r /tmp/idea.tar.gz
