#!/bin/bash

set -ouex pipefail

GEOSERVER_VERSION="2.28.1"
SRC_URL="https://sourceforge.net/projects/geoserver/files/GeoServer/${GEOSERVER_VERSION}/geoserver-${GEOSERVER_VERSION}-bin.zip"

curl --progress-bar -L --retry 5 --retry-delay 10 -o /tmp/geoserver.zip $SRC_URL

install -d /usr/lib/geoserver

unzip /tmp/geoserver.zip -d /usr/lib/geoserver

chown -R student: /usr/lib/geoserver
chown student: /usr/bin/geoserver-start
chown student: /usr/bin/geoserver
chmod +x /usr/bin/geoserver-start
chmod +x /usr/bin/geoserver

# cleanup
rm -rf /tmp/geoserver.zip
